% Generated by roxygen2 (4.0.2): do not edit by hand
\name{netdist}
\alias{netdist}
\title{Network distance}
\usage{
netdist(Y, countdown = FALSE)
}
\arguments{
\item{Y}{(matrix) The sociomatrix. Any positive values of \code{Y} are taken
to indicate a link. Negative values are not taken to be links.}

\item{countdown}{(logical) If true, the progress of the algorithm is
printed out.}
}
\value{
A matrix of the same dimension as \code{Y}, giving the distance (minimal
path length) between nodes.
}
\description{
Minimal directed pathlength between nodes in a network.
}
\details{
The directed distance between nodes of a binary network are computed,
making use of the fact that the sociomatrix raised to a given power
indicates the existence of paths of a given length between nodes.
}
\examples{
data(addhealth3)
Y<-el2sm(addhealth3$E)
netdist(Y)
netdist(Y+t(Y))
}
\author{
Peter Hoff
}

