% Generated by roxygen2 (4.0.2): do not edit by hand
\name{xnet}
\alias{xnet}
\title{Network embedding}
\usage{
xnet(Y, fm = suppressWarnings(require(network)), seed = 1)
}
\arguments{
\item{Y}{(square matrix) The sociomatrix.}

\item{fm}{(logical scalar) If TRUE, the Fruchterman-Reingold layout will
be used (requires the network package).}

\item{seed}{(integer) The random seed (the FR layout is random).}
}
\value{
(matrix) A matrix of two-dimensional coordinates.
}
\description{
Compute an embedding of a sociomatrix into a two-dimensional space.
}
\details{
Coordinates are obtained using the Fruchterman-Reingold layout if the
package \code{network} is installed, and otherwise uses the first two
eigenvectors the sociomatrix.
}
\examples{
data(addhealth3)
Y<-el2sm(addhealth3$E)
X<-xnet(Y)
netplot(Y,X)
}
\author{
Peter Hoff
}

