% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rda.R
\name{concomp}
\alias{concomp}
\title{Connected components of a network}
\usage{
concomp(Y)
}
\arguments{
\item{Y}{(matrix) The sociomatrix. Any positive values of \code{Y} are taken
to indicate a link. Negative values are not taken to be links.}
}
\value{
A list in which each element is a vector of nodes that belong to a
connected component.
}
\description{
Obtain the connected components of a network.
}
\details{
Connected components are identified essentially by identifying the
existence of directed paths between nodes. Note that the connected
components of \code{Y} and \code{t(Y)} may differ.
}
\examples{
data(addhealth3)
Y<-el2sm(addhealth3$E)
concomp(Y)
concomp(t(Y))
concomp(Y+t(Y))
}
\author{
Peter Hoff
}

