% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rda.R
\name{degrees}
\alias{degrees}
\title{Outdegree and indegrees}
\usage{
degrees(Y, dichotomize = TRUE)
}
\arguments{
\item{Y}{(matrix) The sociomatrix.}

\item{dichotomize}{(logical) If true, converts any non-zero entries of \code{Y} to 1 for calculation of the degrees.}
}
\value{
A list consisting of the row degrees (\code{rdeg}) and the
column degrees (\code{cdeg}).
}
\description{
Calculation of the outdegrees and indegrees of a sociomatrix.
}
\details{
The outdegree of a binary sociomatrix may be defined as the row sums
of the non-diagonal elements of the sociomatrix. If the relations are
valued, then the outdegree may be defined as either the outdegree of
of a dichotomized version of the sociomatrix (\code{dichotomize=TRUE}),
or as the row sums of the original sociomatrix (\code{dichotomize=FALSE}).
Note that if non-diagonal elements of a row are missing, the degree for
that row is missing as well. The indegrees are computed analogously.
}
\examples{
data(conflict90s)
# For valued relations, 'dochotomize' makes a difference
degrees(conflict90s$conflicts)
degrees(conflict90s$conflicts,dichotomize=TRUE)
}
\author{
Peter Hoff
}

