% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rda.R
\name{nulldplot}
\alias{nulldplot}
\title{Null distribution plot}
\usage{
nulldplot(to, tH, xlab = "tH", ncol = "lightblue", ocol = "red",
  otype = 1, xlim = range(c(to, tH)), ...)
}
\arguments{
\item{to}{(scalar) The observed value of the test statistic.}

\item{tH}{(vector) Values of the statistic from the null distribution.}

\item{xlab}{(character) Label for the x-axis.}

\item{ncol}{(character) Color of the null histogram.}

\item{ocol}{(character) Color for the observed value.}

\item{otype}{(character) Color for the observed value line type.}

\item{xlim}{(vector) Range for the x-axis.}

\item{\ldots}{Additional plotting characters.}
}
\description{
A plot comparing a null distribution to a test statistic.
}
\details{
This function produces a plot that facilitates comparison
between a distribution of values of a scalar (e.g. a null
distribution of a statistic) to a particular value (e.g.
the observed value of the statistic).
}
\examples{
nulldplot(2,rnorm(1000))
}
\author{
Peter Hoff
}

