GPUmix = function(X,					#Data (N,P)
				K=16,					#Maximum Number of Components
				workdir=".",			#Location of your executables. 
				algorithm="bem",		#Desired Algorithm, must be either "bem" or "mcmc"
				relabel=FALSE,			#should bem create a reference OR should mcmc use Z to relabel?
				m0=rep(0,dim(X)[2]),	#Prior mean on component means. mu_j~N(m0,gamma*Sigma_j)
				nu=2,			#Prior degrees of freedom for IW. Sigma_j~IW(nu,nu*eta_j*Phi0)
				phi0=1,					#Diagonal Elements of Phi0
				gamma=2,				
				e=1,					#alpha ~ gamma(e,f)
				f=1,
				iter=100,				#Number of iterations for MCMC and maximum number of iterations for BEM
				seed=1,					
				burnin=100,				#Number of burnin iterations for MCMC
				printout=10,			#How often the program prints it's status. -1 Suppresses all output.
				percenterr=0.001,		#Percent Error Tolerance in likelihodd for BEM
				mu=NULL,				#Starting Values for Component Means (KxP)
				Sigma=NULL,				#Starting Values for Component Covariances (PxPxK Array)
				pi=NULL,				#Starting Values for Component Weights (K Vector)
				Z=NULL,					#Reference labeling vector for MCMC
				gpu=FALSE,				#If true, a GPU binrary will be called
				gpuChunk=NULL,			#Chunksize for GPU
				gpuNumDev=NULL,			#Number of GPUs in multi GPU MCMC
				gpuDevice=NULL			#Which GPU to use (or start with in multi GPU MCMC)
				){		
	
	info = Sys.info()
	
	if(info[1]=="Windows"){
		dirsep="\\"
	} else {
		dirsep="/"
	}
	
	if(!(algorithm=="mcmc" || algorithm=="bem")){
		cat("algorithm be either bem or mcmc\n")
		return(FALSE)}
		
	N = dim(X)[1]
	D = dim(X)[2]
		
	if(algorithm=="mcmc" && relabel){
		if(is.null(Z)){
			cat("you must specify a reference Z. Usually, this comes from BEM.")
			return(FALSE)}
		if(!(length(Z)==N)){
			cat("Z must be a vector of length N")
			return(FALSE)}}
	
	write.table(X,paste(c(workdir,"mydata.txt"),collapse=dirsep),sep="\t",row.names=FALSE, col.names=FALSE)
	
	out = as.matrix(t(c("algorithm = ",algorithm)))
	out = rbind(out,t(c(" "," ")))
	out = rbind(out,t(c("#data section"," ")))
	out = rbind(out,t(c("N = ",format(N,scientific=FALSE))))
	out = rbind(out,t(c("D = ",D)))
	out = rbind(out,t(c("DataFile = ",paste(c(workdir,"mydata.txt"),collapse=dirsep))))
	out = rbind(out,t(c(" "," ")))
	out = rbind(out,t(c("#prior section"," ")))
	out = rbind(out,t(c("J = ",1)))
	out = rbind(out,t(c("T = ",K)))
	out = rbind(out,t(c("m0 = ",paste(as.character(m0),collapse=" "))))
	out = rbind(out,t(c("nu = ",nu)))
	out = rbind(out,t(c("phi0 = ",phi0)))
	out = rbind(out,t(c("gamma = ",gamma)))
	out = rbind(out,t(c("ee = ",e)))
	out = rbind(out,t(c("ff = ",f)))
	out = rbind(out,t(c(" "," ")))
	out = rbind(out,t(c("#iterate section "," ")))
	out = rbind(out,t(c("iter = ",format(iter,scientific=FALSE))))
	out = rbind(out,t(c("seed = ",seed)))
	out = rbind(out,t(c("burnin = ",format(burnin,scientific=FALSE))))
	out = rbind(out,t(c("printout = ",format(printout,scientific=FALSE))))
	out = rbind(out,t(c("percenterr = ",format(percenterr,scientific=FALSE))))
	out = rbind(out,t(c(" "," ")))
	if(gpu){
		out = rbind(out,t(c("#GPU Section "," ")))
		if(!(is.null(gpuChunk))){
			out = rbind(out,t(c("GPUNCHUNKSIZE = ",format(gpuChunk,scientific=FALSE))))}
		if(!(is.null(gpuNumDev))){
			out = rbind(out,t(c("numberdevices = ",gpuNumDev)))}
		if(!(is.null(gpuDevice))){
			out = rbind(out,t(c("device = ",gpuDevice)))}
		}
	out = rbind(out,t(c(" "," ")))
	if(!(is.null(mu))){
		write.table(mu,file=paste(c(workdir,"initmu.txt"),collapse=dirsep),sep="\t",row.names=FALSE,col.names=FALSE)
		out = rbind(out,t(c("mufile = ",paste(c(workdir,"initmu.txt"),collapse=dirsep))))}
	if(!(is.null(Sigma))){
		tmp=t(matrix(t(as.matrix(Sigma)),nrow=D*D,ncol=K))
		write.table(tmp,file=paste(c(workdir,"initsigma.txt"),collapse=dirsep),row.names=FALSE,col.names=FALSE,sep="\t")
		out = rbind(out,t(c("sigmafile = ",paste(c(workdir,"initsigma.txt"),collapse=dirsep))))}
	if(!(is.null(pi))){
		write.table(t(pi),file=paste(c(workdir,"initpi.txt"),collapse=dirsep),row.names=FALSE,col.names=FALSE,sep="\t")
		out = rbind(out,t(c("pfile = ",paste(c(workdir,"initpi.txt"),collapse=dirsep))))}
	if(algorithm=="bem"){
		out = rbind(out,t(c(" "," ")))
		out = rbind(out,t(c("#relabeling section "," ")))
		out = rbind(out,t(c("emRefFile = ",paste(c(workdir,"lastz.txt"),collapse=dirsep))))}
	if(relabel){
		if(algorithm=="mcmc"){
			out = rbind(out,t(c(" "," ")))
			out = rbind(out,t(c("#relabeling section "," ")))
			write.table(Z,file=paste(c(workdir,"refz.txt"),collapse=dirsep),row.names=FALSE,col.names=FALSE,sep="\t")
			out = rbind(out,t(c("mcmcRelabelRef = ",paste(c(workdir,"refz.txt"),collapse=dirsep))))}}
	
		
	write.table(out,file=paste(c(workdir,"parameters.txt"),collapse=dirsep),row.names=FALSE,col.names=FALSE,quote=FALSE)
	
	if(info[1]=="Darwin"){
		execname="cdpsmac"
	} else if(info[1]=="Linux"){
		if(info[5]=="x86"){
			execname="cdpslinux64"
		}else{
			execname="cdpslinux32"
		}
	} else if(info[1]=="Windows"){
		if(info[5]=="x86"){
			execname="cdpem64"
		}else{
			execname="cdpem32"
		}
	}
	if(gpu){
		if(!(info[1]=="Darwin" || info[5]=="x86")){
			cat("Sorry, there is no GPU binary for your 32bit OS\n")
			return(FALSE)
		} else {
			Sys.setenv(DYLD_LIBRARY_PATH="/usr/local/cuda/lib")
			Sys.setenv(LD_LIBRARY_PATH="/usr/local/cuda/lib")
			execname = paste(c(execname,"_cuda"),collapse="")
		}
	}
	
	system(paste(c(workdir,dirsep,execname," ",workdir,dirsep,"parameters.txt"),collapse=""))
	
	if(algorithm=="bem"){
		EMmu = as.matrix(read.table("lastMu.txt"))
		EMalpha = as.matrix(read.table("lastalpha.txt"))[1,1]
		EMpi = as.matrix(read.table("lastp.txt"))
		EMpostLL = as.matrix(read.table("lastPostLL.txt"))[1,1]
		EMpV = as.matrix(read.table("lastpV.txt"))
		EMsigma = as.matrix(read.table("lastSigma.txt"))
		EMsigma = array(EMsigma,c(K,D,D))
		EMsigma = aperm(EMsigma,c(2,3,1))
		if(relabel){EMZ = as.matrix(read.table(paste(workdir,"/","lastz.txt",sep = "")))} else {EMZ = NULL}
		return(list(pi=EMpi,mu=EMmu,Sigma = EMsigma, pV=EMpV,alpha=EMalpha,postLL=EMpostLL,Z=EMZ))
	}
	if(algorithm=="mcmc"){
		MCmu = as.matrix(read.table("postmu.txt"))
		MCmu = aperm(array(t(MCmu),c(D,K,iter)),c(2,1,3))
		MCpi = as.matrix(t(read.table("postp.txt")))
		MCsigma = as.matrix(read.table("postSigma.txt"))
		MCsigma = array(t(MCsigma),c(D,D,K,iter))
		return(list(pi=MCpi,mu=MCmu,Sigma=MCsigma))
	}
		
	
	
}
