dat<-dget("cities.rdat")
Y0<-dat$Y
X<-dat$X

m<-dim(Y0)[1]
n<-dim(Y0)[2]

seed<-1
set.seed(seed)
GRP<-matrix(sample(rep(1:10,m*n/10)),m,n)

mu.one<-0

par(mfrow=c(3,3))
LPY<-NULL
for(Kadd in c(0:10) ) {
lpy1<-lpy2<-0
plot(c(0,200),c(4,6),type="n")

E1<-E2<-Y1p <-Y2p<-Y0
for(cv in 1:10) {
fname<-paste("cv",cv,"K",Kadd,"mu",mu.one,sep="")
EY1<-dget(paste("CV/EY1.",fname,sep=""))
EY2<-dget(paste("CV/EY2.",fname,sep=""))
lpy1<-lpy1+ sum( dbinom(Y0[GRP==cv],1,EY1[GRP==cv],log=T) ) 
lpy2<-lpy2+ sum( dbinom(Y0[GRP==cv],1,EY2[GRP==cv],log=T) )
lines(dget(paste("CV/OUT.",fname,sep=""))[,6], col=cv) 
E1[GRP==cv]<-EY1[GRP==cv]
E2[GRP==cv]<-EY2[GRP==cv]
Y1p[GRP==cv]<-1*(EY1[GRP==cv]>.5) 
Y2p[GRP==cv]<-1*(EY2[GRP==cv]>.5)
                }
res<-c(lpy1,lpy2, mean(Y0==Y1p) ,mean(Y0==Y2p),mean((Y0-E1)^2),
                 mean( (Y0-E2)^2)    )
LPY<-rbind(LPY,res)
cat(Kadd,res,"\n")
                       }
plot(0:10,LPY[,4],type="h")

############
pdf("citiesmcmc.pdf",height=2.25,width=6,family="Times" )
OUT<-dget("Results/OUT.mu0")
par(mfrow=c(1,3),mar=c(2.75,2.75,1,1),mgp=c(1.75,.75,0),cex=.75)
outplot<-OUT[ 20*(1:250)  ,2]
plot( 100*(1:250), outplot,type="l" ,xlab="scan",ylab="K") 
plot(   table(OUT[,2]-2)/length(OUT[,2]), xlab="K",ylab="p(K|Y)" )
plot(0:10,-2*LPY[,1],type="h",xlab="K",ylab=
     expression( paste( "-2 log p(Y|", hat(theta), ")",sep="")),lwd=2)
dev.off()


##############
M3<-dget("Results/M3.pm.mu0")
sM3<-svd(M3)
pdf("cities.pdf",height=5,width=5,family="Times" )

#par(mfrow=c(1,1),mar=c(1,1,1,1),xaxt="n",yaxt="n")
par(mfrow=c(1,1),mar=c(2.75,2.75,1,1),mgp=c(1.75,.75,0),cex=1)
plot(sM3$u[,1:2]*1.2,type="n",xlab=expression(hat(u[1])),
                               ylab=expression(hat(u[2])) )
text(sM3$u[,1],sM3$u[,2],rownames(Y0) )
abline(h=0,col="gray",lty=2)
abline(v=0,col="gray",lty=2)

dev.off()



