##### Precondition: Y= m*n  matrix with m>=n
m<-dim(Y)[1]
n<-dim(Y)[2]

source("svd.f.r")
seed<-1
set.seed(1)


Xrows<-matrix(nrow=m,ncol=0) ; Xcols<-matrix(nrow=n,ncol=0)
##### hyperparameters

phi<- 1

t20<-100
eta0<-2

mu0<-sqrt(n+m+2*sqrt(n*m))*mu.one
premu0<-1/100

## prior for beta
Pb0<-diag(1/100,nrow=dim(X)[3])
iPb0<-solve(Pb0)
mub0<-rep(0,dim(X)[3])


##### starting values
glmfit<-glm(c(Y)~-1+x.X(X),family="binomial" )
beta<-glmfit$coef*1.15
mu<-mu0
psi<-1/t20

r<-c(Y)
r[!is.na(r)]<-resid(glmfit,type= c("deviance"))
r[is.na(r)]<-rnorm(sum(is.na(r)),0,sd(r,na.rm=T))
R<-matrix(r,nrow=m,ncol=n,byrow=F)
diag(R)<-rnorm(n,0,sd(r,na.rm=T))
U<-matrix(0,m,n) ; D<-V<-matrix(0,n,n)  

### column effects
U[,1]<-rep(1/sqrt(m),m) 
V[,1]<- apply(R,2,mean) 
V[,1]<-V[,1]-mean(V[,1])
D[1,1]<-sqrt(sum(V[,1]^2)) 
V[,1]<-V[,1]/D[1,1]

###row effects
V[,2]<-rep(1/sqrt(n),n)
U[,2]<- apply(R,1,mean)
U[,2]<-U[,2]-mean(U[,2])
D[2,2]<-sqrt(sum(U[,2]^2))
U[,2]<-U[,2]/D[2,2]

sR<-svd(R)
U[,2+seq(1,Kadd,length=Kadd)]<-sR$u[,seq(1,Kadd,length=Kadd)]
V[,2+seq(1,Kadd,length=Kadd)]<-sR$v[,seq(1,Kadd,length=Kadd)]
D[ 2+seq(1,Kadd,length=Kadd),2+seq(1,Kadd,length=Kadd) ] <-
 diag( sR$d[seq(1,Kadd,length=Kadd)],nrow=Kadd) 


Theta<-  XB(X,beta) + U%*%D%*%t(V) + matrix(rnorm(m*n,0,1/sqrt(phi)),m,n)
#####

##### MCMC
NSCAN<-25000
odens<-50
OUT<-NULL
MSE<-NULL
M.ps<-M3.ps<-EY1.ps<-EY2.ps<-matrix(0,m,n)
for(ns in 1:NSCAN) {

######### updates

##### var rank update
#gibbs.UVD.rc.varrank(U,V,D,Theta-XB(X,beta),phi,mu,psi,min(n,round(m/10)),
#                     Xrows,Xcols)
#####

##### fixed rank update
gibbs.UVD.rc.fixedrank(U,V,D,Theta-XB(X,beta),phi,mu,psi,Xrows,Xcols)
#####

##### propose new linear part
XBE <- Theta - U%*%D%*%t(V)
x<-x.X(X)
vr<- solve(  phi*t(x)%*%x  +  Pb0   )
mn<- vr%*%( Pb0%*%mub0 +  phi*t(x)%*%c(XBE) )
beta<-rmvnorm(mn,vr)
#####

##### update predictor
Theta.p<- XB(X,beta) +  U%*%D%*%t(V) + matrix(rnorm(m*n),m,n)/sqrt(phi)
llr<- lpY.binary(Y,Theta.p) - lpY.binary(Y,Theta)
llr[is.na(llr)]<-0
lptr<-0
lar<-llr+lptr
accept<-  log(matrix(runif(m*n),m,n)) <lar
Theta[accept] <-Theta.p[accept]
###

M.ps<-M.ps+U%*%D%*%t(V)

##### output
if(ns> NSCAN/2 ) {
EY1.ps<-EY1.ps + 1/( 1+exp(-Theta) )
EY2.ps<-EY2.ps + 1/( 1+exp( -beta[1]-U%*%D%*%t(V) ) )
                 }                   

if(ns %% odens==0) {
M.pm<-M.ps/ns
out<-c(ns,sum(D!=0),beta,mu,1/psi,mean( (M.pm)^2) )
OUT<-rbind(OUT,out)
cat(out,"\n")
dput(OUT,paste("CV/OUT.",fname,sep=""))
dput(EY1.ps/(ns-NSCAN/2),paste("CV/EY1.",fname,sep=""))
dput(EY2.ps/(ns-NSCAN/2),paste("CV/EY2.",fname,sep=""))

		    }

         }


