##### Precondition: Y= m*n  matrix with m>=n
dat<-dget("cities.rdat")
Y<-dat$Y; X<-dat$X 
m<-dim(Y)[1]
n<-dim(Y)[2]

source("svd.f.r")
seed<-1
set.seed(1)


Xrows<-matrix(nrow=m,ncol=0) ; Xcols<-matrix(nrow=n,ncol=0)
dirname<-"Results"
##### hyperparameters

phi<- 1

t20<-100
eta0<-2

mu0<-sqrt(n+m+2*sqrt(n*m))*0
premu0<-1/100

## prior for beta
Pb0<-diag(1/100,nrow=dim(X)[3])
iPb0<-solve(Pb0)
mub0<-rep(0,dim(X)[3])


##### starting values
glmfit<-glm(c(Y)~-1+x.X(X),family="binomial" )
beta<-glmfit$coef
mu<-mu0
psi<-1/t20

r<-c(Y)
r[!is.na(r)]<-resid(glmfit,type= c("deviance"))
R<-matrix(r,nrow=m,ncol=n,byrow=F)
diag(R)<-rnorm(n,0,sd(r,na.rm=T))
U<-matrix(0,m,n) ; D<-V<-matrix(0,n,n)  

### column effects
U[,1]<-rep(1/sqrt(m),m) 
V[,1]<- apply(R,2,mean) 
V[,1]<-V[,1]-mean(V[,1])
D[1,1]<-sqrt(sum(V[,1]^2)) 
V[,1]<-V[,1]/D[1,1]

###row effects
V[,2]<-rep(1/sqrt(n),n)
U[,2]<- apply(R,1,mean)
U[,2]<-U[,2]-mean(U[,2])
D[2,2]<-sqrt(sum(U[,2]^2))
U[,2]<-U[,2]/D[2,2]

Theta<-  XB(X,beta) + U%*%D%*%t(V) + matrix(rnorm(m*n,0,1/sqrt(phi)),m,n)
#####

##### MCMC
NSCAN<-25000
odens<-5
OUT<-NULL
MSE<-NULL
M.ps<-M3.ps<-EY.ps<-matrix(0,m,n)
for(ns in 1:NSCAN) {

######### updates

##### var rank update
gibbs.UVD.rc.varrank(U,V,D,Theta-XB(X,beta),phi,mu,psi,min(n,round(m/10)),
                     Xrows,Xcols)
#####

##### fixed rank update
gibbs.UVD.rc.fixedrank(U,V,D,Theta-XB(X,beta),phi,mu,psi,Xrows,Xcols)
#####

##### propose new linear part
XBE <- Theta - U%*%D%*%t(V)
x<-x.X(X)
vr<- solve(  phi*t(x)%*%x  +  Pb0   )
mn<- vr%*%( Pb0%*%mub0 +  phi*t(x)%*%c(XBE) )
beta<-rmvnorm(mn,vr)
#####

##### update predictor
Theta.p<- XB(X,beta) +  U%*%D%*%t(V) + matrix(rnorm(m*n),m,n)/sqrt(phi)
llr<- lpY.binary(Y,Theta.p) - lpY.binary(Y,Theta)
llr[is.na(llr)]<-0
lptr<-0
lar<-llr+lptr
accept<-  log(matrix(runif(m*n),m,n)) <lar
Theta[accept] <-Theta.p[accept]
###



##### output
M.ps<-M.ps+U%*%D%*%t(V)
M3.ps<-M3.ps+ U[,-(1:2)]%*%D[-(1:2),-(1:2)]%*%t(V[,-(1:2)])
EY.ps<-EY.ps + 1/( 1+exp(-Theta) )
if(ns %% odens==0) {
M.pm<-M.ps/ns
out<-c(ns,sum(D!=0),beta,mu,1/psi,mean( (M.pm)^2),mean(U%*%D%*%t(V)) )
OUT<-rbind(OUT,out)
cat(out,"\n")

dput(OUT,paste(dirname,"/OUT.mu",1*(mu0>0),sep=""))
dput(M.ps/ns,paste(dirname,"/M.pm.mu",1*(mu0>0),sep=""))
dput(EY.ps/ns,paste(dirname,"/EY.pm.mu",1*(mu0>0),sep=""))
dput(M3.ps/ns,paste(dirname,"/M3.pm.mu",1*(mu0>0),sep=""))

#par(mfrow=c(2,3))
#plot( Theta, XB(X,beta) +  U%*%D%*%t(V)   )
#points( Theta[Y==1] , ( XB(X,beta) +  U%*%D%*%t(V) )[Y==1],col="blue",pch=16)
#plot(OUT[,2]);plot(table(OUT[,2]));plot(OUT[,3]);plot(OUT[,13])
#dT<-svd(Theta-XB(X,beta))$d
#plot(dT[1:20],ylim=range(c(dT,abs(D))))
#points(-sort(-diag(abs(D))),type="h",col="blue")
#points( svd(M.pm)$d,col="red")
                   }



#####

         }
##### end mcc




