\name{Null}
\alias{Null}
\title{Basis for the null space of a matrix}
\description{
 Generates an orthonormal basis for the null space of a matrix.
 This is a slight modification of the function "Null" in the 
 MASS package, modified so that a vector of column-length zero 
 returns the identity matrix.  
   
}
\usage{
Null(M)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{M}{ A matrix }
}

\value{ An orthonormal matrix
       }
\author{Peter Hoff }
\examples{
 x<-matrix(nrow=10,ncol=0)
 Null(x)
  
 X<-matrix(rnorm(10*5),10,5) 
 Null(X)


## The function is currently defined as
function(M) 
{
    tmp <- qr(M)
    set <- if (tmp$rank == 0) 
            1:nrow(M)  #modified from package MASS 
    else -(1:tmp$rank)
    qr.Q(tmp, complete = TRUE)[, set, drop = FALSE]
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{algebra}
