`covreg.mcmc` <-
function(formula,data=NULL,method=1,
r=1,niter=1000,nthin=1,nsave=niter/nthin,verb=T){
##########################################
model=model.frame(formula,data)
Y=model.response(model)
x=model.matrix(formula,model)

n=dim(Y)[1]
p=dim(Y)[2]
q=dim(x)[2]
if (method==2){
xx=NULL
for (i in 1:r){
xx=cbind(xx,x)
}
}
## priors ##
gg=1/n
nu0=p+2
A0=cov(Y)
V0=gg*t(x)%*%x
if (method==2) V02=gg*t(xx)%*%xx

## starting values ##
B=array(rnorm(p*q*r),dim=c(p,q,r))
g=matrix(rnorm(n*r),ncol=r)
xg=array(dim=c(n,q,r))
for (i in 1:r){
xg[,,i]=x*g[,i]
}
A=cov(Y)
##################################################
## prep functions ##
tbf=function(Y,xg,A){
t(Y)%*%xg%*%solve(t(xg)%*%xg+A)
}

xb=function(xx,b){
XB=0
d=dim(b)[3]
if (is.na(d)) XB=xx%*%t(b)
if((!is.na(d))&(d>0)) {
for (i in 1:d){
XB=XB+xx[,,i]%*%t(b[,,i])
}
}
XB
}

ts=function(Y,xg,B){
d=Y-xb(xg,B)
s=t(d)%*%d
s
}


rmn=function (M = 0, Srow, Scol){
m=dim(Srow)[1]
n=dim(Scol)[1]
      tmp=eigen(Srow)
Srow.h=tmp$vec %*% diag(sqrt(tmp$val),nrow=m) %*% t(tmp$vec)
tmp=eigen(Scol)
Scol.h=tmp$vec %*% diag(sqrt(tmp$val),nrow=n) %*% t(tmp$vec)
Z=matrix(rnorm(m * n), m, n)
Srow.h %*% Z %*% Scol.h + M
}

rwish=function (nu,S0) 
{
    sS0 <- chol(S0)
    Z <- matrix(rnorm(nu * dim(S0)[1]), nu, dim(S0)[1]) %*% sS0
    t(Z) %*% Z
}

riwish=function (v, S) 
{
    return(solve(rwish(v, solve(S))))
}



#######################################

## full conditionals ##
## update A ##
rA_fc=function(Y,xg,B,n,p,r,nu0,A0,V0){
s=ts(Y,xg,B)
for (i in 1:r){
s=s+B[,,i]%*%V0%*%t(B[,,i])
}
s=s+A0
A=riwish(n+r*p+nu0,s)
A
}

## update g ##
rg_fc=function(Y,Bi,Bmi,A,x,xgmi,n){
bx=x%*%t(Bi)
Ai=solve(A)
s2=1/(diag(bx%*%Ai%*%t(bx))+1)
m=diag(bx%*%Ai%*%t(Y-xb(xgmi,Bmi)))*s2
g=rnorm(n,m,sqrt(s2))
g
}

## update B ##
rB_fc=function(Y,xgi,xgmi,Bmi,A,q,V0){
tB=tbf(Y-xb(xgmi,Bmi),xgi,V0)
s=solve(t(xgi)%*%xgi+V0)
B=rmn(tB,A,s)
B
}

###################################################

## update A method 2 ##
rA_fc2=function(Y,xg,B,xx,n,p,r,nu0,A0,V0){
B=matrix(B,nrow=p)
s=(t(Y)-B%*%t(xg))%*%(Y-xg%*%t(B))+B%*%V0%*%t(B)
s=s+A0
A=riwish(n+r*p+nu0,s)
A
}

## update B method 2 ##
rB_fc2=function(Y,xg,xx,A,p,q,r,V0){
tB=t(Y)%*%xg%*%solve(V0+t(xg)%*%xg)
s=solve(t(xg)%*%xg+V0)
b=rmn(tB,A,s)
B=array(b,dim=c(p,q,r))
B
}

################################################

## output ##
b.save=array(dim=c(p,q,r,nsave))
a.save=array(dim=c(p,p,nsave))

############################################
## main loop ##
if (method==1){
for (ns in 1:niter){
for (i in 1:r){
g[,i]=rg_fc(Y,B[,,i],B[,,-i],A,x,xg[,,-i],n)
xg[,,i]=x*g[,i]
}
A=rA_fc(Y,xg,B,n,p,r,nu0,A0,V0)
for (i in 1:r){
B[,,i]=rB_fc(Y,xg[,,i],xg[,,-i],B[,,-i],A,q,V0)
}

if (ns%%nthin==0){
b.save[,,,ns/nthin]=B
a.save[,,ns/nthin]=A
}
if (verb==T & ns%%(niter/100)==0)cat(round(ns/niter*100),"% done",date(), "\n") 
}
}

if (method==2){
for (ns in 1:niter){
for (i in 1:r){
g[,i]=rg_fc(Y,B[,,i],B[,,-i],A,x,xg[,,-i],n)
xg[,,i]=x*g[,i]
}
xg2=matrix(xg,ncol=q*r)
A=rA_fc2(Y,xg2,B,xx,n,p,r,nu0,A0,V02)
B=rB_fc2(Y,xg2,xx,A,p,q,r,V02)

if (ns%%nthin==0){
b.save[,,,ns/nthin]=B
a.save[,,ns/nthin]=A
}
if (verb==T & ns%%(niter/100)==0)cat(round(ns/niter*100),"% done",date(), "\n") 
}
}

return(list(B.psamp=b.save,A.psamp=a.save))
}

