\name{covreg-package}
\alias{covreg-package}
\alias{covreg}
\docType{package}
\title{
Fit a covariance regression model to multivariate response variables.
}
\description{
Fit covariance matrices of multivariate response variables given different covariate values.
}
\details{
\tabular{ll}{
Package: \tab covreg\cr
Type: \tab Package\cr
Version: \tab 0.75\cr
Date: \tab 2009-12-14\cr
License: \tab What license is it under?\cr
LazyLoad: \tab yes\cr
}
}
\author{
Peter Hoff and Xiaoyue Niu

Maintainer: Xiaoyue Niu <xiaoyue@stat.washington.edu>
}
\references{
}
\keyword{ package }
\examples{
## load FEV data ##
data(fev)
## use centered square root of age as a single predictor ##
X=sqrt(fev$age)
X=X-mean(X)
## Use fev and height as response Y, remove mean effects of X from Y ##
Y=cbind(fev$fev,fev$height)
Y[,1]=loess(Y[,1]~X)$residuals
Y[,2]=loess(Y[,2]~X)$residuals
## fit covariance regression model using EM##
fit.em=covreg.em(Y~X)
fit.mcmc=covreg.mcmc(Y~X)
}
