function deltatee = LogIt(logString, logLevel, logThresh, showDelta)
%
% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
% Log strings if they should be logged...
% logString = the thing to log
% logLevel = the urgency level deemed for this message
% logThresh = the existing threshold for logging
%
% If logLevel <= logThresh, the message will be displayed
%
% TBD: encapsulate output filename/fid in one of the arguments
% 
% SIDE EFFECT: calls tic() if exception is thrown by toc()
%
persistent lasttime;

if nargin < 2
    logLevel = 1;
    logThresh = 1;
    showDelta = 0;
elseif nargin < 3
    logThresh = logLevel;
    showDelta = 0;
elseif nargin < 4
    showDelta = 0;
end

if (logLevel <= logThresh)
    
    try
        tocval = toc();
    catch
        tic();
        tocval = toc();
    end

    if numel(lasttime) < 1
        lasttime = tocval;
    end
    
    tocstr = sprintf('%12.3f', tocval);
    diffstr = sprintf('%12.3f', tocval - lasttime);
    
    if nargout > 0
        deltatee = tocval - lasttime;
    end
    
    lasttime = tocval;
    
    if showDelta ~= 0
        tocstr = strcat(tocstr, ':', diffstr);
    end
    
    % Slight hack here: looking for terminal '\n' sequences only
    % Would be BETTER to replace them all, but not now
    if logString(end-1)=='\' && logString(end) == 'n'
        mlstr = logString(1:(end-2));
        lclLogStr = sprintf('[%s] %s\n', tocstr, mlstr);
    else
        lclLogStr = sprintf('[%s] %s', tocstr, logString);
    end
    
    if length(logString) == 17 && strcmp(logString, '*_*_*_RESET_*_*_*') == 1
        % a RESET ONLY message...
    else
        outpname = getenv('OUTPNAME');
        if ( strcmp(outpname, '') ~= 1 )
            [fid,message] = fopen(outpname, 'a');
            if ( fid <= 0 )
                error(message);
                % not reachable
            end

            % For obvious reasons, this cannot be multithreaded!
            % More generally, only one thing at a time should do the writing
            % There COULD be lots of churn and burn on fopen/fclose if you
            % are in the "verbose" logging state.
            % TBD: keep a file descriptor open for the duration of the process
            % TBD: figure out the handling to close that descriptor properly

            fprintf(fid, '%s', lclLogStr);
            sts = fclose(fid);
            if ( sts < 0 )
                % throwaway error at this point
                disp('Error on fclose');
            end
        else
            fprintf(1, '%s', lclLogStr);
        end
    end
end

return;

