% -----------------------------------------------------------------------------
% FILE   : clearenv
% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
% -----------------------------------------------------------------------------
% remove strings from the environment
function clearenv(clearstrs,safestrs)

if nargin < 2
    safestrs = {};
end

for sidx = 1:numel(clearstrs);
    doclear = false;
    if numel(safestrs) < 1
        doclear = true;
    else
        for lidx = 1 : numel(safestrs)
            if strcmp(safestrs{lidx},clearstrs{sidx})
                doclear = false;
                break;
            end
        end
    end
    
    if doclear
        setenv(clearstrs{sidx}, '');
    end
end

end
