% ------------------------------------------------------------------------
% FILE : dirkld
% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
% Evaluates the Kullback-Leibler Divergence
% P = Dirichlet(apee)
% Q = Dirichlet(aqew)
% P is the "truth"
% if numel(apee) == numel(aqew) == 2, s.b. the same as betakld(apee,aqew)
% ------------------------------------------------------------------------
function kld = dirkld(apee, aqew)

if ( numel(apee) ~= numel(aqew) ) || ...
   ( numel(apee) < 2 ) || ...
   ( any(apee <= 0)  ) || ...
   ( any(aqew <= 0)  ) 
    error('Arguments must be the same length, with more than one element, each of which must be positive');
end

A = gammaln(sum(apee));
B = gammaln(sum(aqew));

Cvec = gammaln(aqew) - gammaln(apee);

Dvec = (apee - aqew) .* (psi(apee) - psi(sum(apee)));

kld = A - B + sum(Cvec) + sum(Dvec);

end
