% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
%
% dumpstruct.m
% An attempt to finesse 'disp' for a messy struct
%
function mstr = dumpstruct(marg, padding, nummax)

    if (padding > 0)
        padstr = sprintf('%*.*s', padding, padding, ' ');
    else
        padstr = '';
    end
    
    if nummax <= 0
        nummax = 1;
    end

    mstr = sprintf('%s%20.20s', padstr, strcat('[',class(marg),']'));
    
    fnames = fieldnames(marg);
    
    fsize = size(fnames);
    
    for idx = 1:fsize(1)
        % debug!
        fieldSize = size( marg.(fnames{idx}) );
        logStr = sprintf('%s->%s [%d,%d]', fnames{idx}, class(marg.(fnames{idx})), fieldSize(1), fieldSize(2));
        % disp(logStr);
        LogIt(sprintf('%s\n', logStr), 2, marg.LOGTHRESH);
        
        if ischar( marg.(fnames{idx}) )
            logStr = sprintf('%20s : ''%s''', fnames{idx}, marg.(fnames{idx}));
        elseif isnumeric( marg.(fnames{idx}) )
            if fieldSize(1) == 1 || fieldSize(2) == 1
                maxct = min(nummax, max(fieldSize(1), fieldSize(2)));
                if maxct < max(fieldSize(1), fieldSize(2))
                    contstr = '...';
                else
                    contstr = ' ';
                end
                toprint = marg.(fnames{idx});
                toprint = toprint(1:maxct);
                numStr = sprintf('%.2e ', toprint);
                logStr = sprintf('%20s : [%dx%d numeric] : %s %s',  ...
                    fnames{idx}, fieldSize(1), fieldSize(2), numStr, contstr);
            else
                logStr = sprintf('%20s : [%dx%d numeric]', fnames{idx}, fieldSize(1), fieldSize(2) );
            end
        elseif isstruct( marg.(fnames{idx}) )
            logStr = sprintf('%20s : [%dx%d struct]', fnames{idx}, fieldSize(1), fieldSize(2) );
            structStr = dumpstruct( marg.(fnames{idx}), padding+10, nummax);
            logStr = sprintf('%s\n%s%s', logStr, padstr, structStr);
        elseif islogical( marg.(fnames{idx}) )
            if fieldSize(1) == 1 && fieldSize(2) == 1
                logStr = sprintf('%20s : %d', fnames{idx}, marg.(fnames{idx}));
            else
                logStr = sprintf('%20s : [%dx%d logical]', fnames{idx}, fieldSize(1), fieldSize(2) );
            end
        else
            logStr = sprintf('%20s : %s', fnames{idx}, class( marg.(fnames{idx}) ) );
        end
        
        mstr = sprintf('%s\n%s%s', mstr, padstr, logStr);
    end
    
    mstr = sprintf('%s\n', mstr);
return;
