% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
%
% Using a cell array of strings, define new fields
%
function marg = getenvargs(oarg, envstrs)

marg = oarg;
defwarnstr = 'WARNINGS :';
marg.warnings = defwarnstr;

warnfmt = strcat('dowarn = (strcmpi(class(marg.%s),''char'')', ...
                 '&& any(isempty(marg.%s))) ', ...
                 '||', ...
                 '(strcmpi(class(marg.%s),''char'')==0 ', ...
                 '&& any(isnan(marg.%s(:))));');

for sidx = 1:length(envstrs)
    argname = upper(envstrs{sidx});
    evstr = strcat('marg.', argname, 'Arg = getenv(''', argname, ''');');
    try 
        eval(evstr);
    catch ME
        error('Bad getenv on [%s]:[%s]', argname, ME.message);
    end
    
    evstrA = strcat('mstr = marg.', argname, 'Arg;');
    try
        eval(evstrA);
    catch ME
        error('Bad eval on [%s] placeholder : [%s]', argname, ME.message);
    end
    
    % At this point, 'mstr' is a variable in the current space that we can
    % use, test etc
    stringtreat = 0;
    
    if exist(mstr) > 1
        stringtreat = 1;
    else
        evstrB = strcat('marg.', argname, ' = [' , mstr, '];');
        try
            eval(evstrB);
        catch
            % We will treat an error here as an indication that this is a
            % string - possibly dangerous...
            stringtreat = 1;
        end
    end
    
    if stringtreat == 1 || isempty(mstr)
        evstrC = strcat('marg.', argname, ' = marg.', argname, 'Arg;');
        try
            eval(evstrC);
        catch
            error('Cannot deal with [%s] arg', argname);
        end
    end
    
    % Handle some special cases
    if strcmpi(argname, 'LOGTHRESH');
        marg.logthresh = marg.LOGTHRESH;
    elseif strcmpi(argname, 'RSEED');
        marg.rseed = marg.RSEED;
        if isempty(marg.rseed)
            marg.rseed = NaN;
        end
    elseif strcmpi(argname, 'NSEED');
        marg.nseed = marg.NSEED;
        if isempty(marg.nseed)
            marg.nseed = NaN;
        end
    elseif strcmpi(argname, 'SEED');
        marg.seed = marg.SEED;
        if isempty(marg.seed)
            marg.seed = NaN;
        end
    end
    
    % Append to a list of WARNINGS
    dowarn = 1;
    evstrE = sprintf(warnfmt, argname, argname, argname, argname);

    try
        eval(evstrE);
    catch ME
        error('Trouble evaluating marg.%s, %s', argname, ME.message);
    end
    
    if dowarn && strcmpi(marg.warnings, defwarnstr) 
        marg.warnings = strcat(marg.warnings, ' ', argname);
    elseif dowarn
        marg.warnings = strcat(marg.warnings, ', ', argname);
    end
        
end

if strcmpi(marg.warnings, defwarnstr)
    marg.warnings = 'WARNINGS : <NONE>';
end

end
