% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
% getmarger
% create a summing matrix that computes marginals from an ordered vector
function marger = getmarger(dvec)

marger = zeros(max(dvec)*numel(dvec), prod(dvec));

menum = idx2vec(1:prod(dvec), dvec);

midx = 1;
for jidx = 1 : numel(dvec)
    for cidx = 1 : max(dvec)
        marger(midx,:) = (menum(:,jidx)==cidx).';
        midx = midx+1;
    end
end

end
