%
% iterative proportional fitting
% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
% p-Dimensional
% Returns indices and a vector that can be summed/reshaped as desired
%
% NOTE: this always starts with a uniform SEED value.  This is not as
% generally applicable as the stuff in the R "cat" package, since in that
% case you have some set of observations already filling in the contingency
% table and you want to adjust them to match the provided marginals.
%
% A more common way to use IPF is when you have a given observed
% contingency table and you want to adjust it so that its margins match
% what you know from another source.
%
function fitmat = iterpropfitPdim(truedist, dvec)

mblock = idx2vec(1:prod(dvec), dvec);

bigM = ones(size(mblock,1),1);
eta = 1;
keepgoing = 1;
mdiffs = zeros(100,1);
while eta <= 100  && keepgoing
    bigMx = zeros(size(bigM,1), size(mblock,2)+1);
    bigMx(:,1) = bigM;
    
    % For each row in bigM, find matching marginals
    
    for eidx = 2:size(bigMx,2)
        for ridx = 1:size(mblock,1);
            for didx = 1:size(mblock,2);
                % LogIt(sprintf('%5d %5d %5d\n', eidx, ridx, didx), 1, 1);
                bigMx(ridx,eidx) = bigMx(ridx,eidx-1) * truedist(mblock(ridx,eidx-1),eidx-1);
                selidx = mblock(:,eidx-1) == mblock(ridx,eidx-1);
                bigMx(ridx,eidx) = bigMx(ridx,eidx) / sum(bigMx(selidx,eidx-1));
            end
        end
    end
    
    mdiffs(eta) = sum(bigMx(:,end) - bigMx(:,1));
    bigM = bigMx(:,end);
    
    if mdiffs(eta) < 1e-3;
        keepgoing = 0;
    end
    
    eta = eta + 1;
    
end

fitmat = [mblock bigM];

end
