# -------------------------------------------------------------------------
# Plot the results from the simulation study for the PUMS example
# AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
# -------------------------------------------------------------------------

# -- ADJUST FOR YOUR LOCAL CONDITIONS
srcdir = "C:/cygwin/tmp/RERUN";
outdir = "C:/cygwin/tmp/RERUN";

srcfile = paste(srcdir, "/resultsCOMB.txt", sep="");

uplim=40000;

restbl = read.table(srcfile, sep=",", col.names=c("NTRAIN","LDF1","LDF2","LDF3","LDF4","MARG1","MARG2","MARG3","MARG4"));
restbl = restbl[, c("NTRAIN","LDF1","LDF3","LDF4","MARG1","MARG3","MARG4")];

legstrs = c("I","MSP","N");
qtys = c(4,1);

# -- Filter for sample sizes
selidx = restbl$NTRAIN <= uplim;
restbl = restbl[selidx,];

pdf(sprintf("%s/fig1152_m%3.3d.pdf", outdir, floor(uplim/1000)), 
    family="Times", width=7, height=4);

nvals = sort(unique(restbl$NTRAIN));
nvals = nvals[nvals <= uplim];

nlocs = seq(1, length(nvals), 1);
ylabs = c("log M_k", "log L_k");
mainlbls = c("Marginal Metric", "Margin-Free Metric");

# par(mfrow=c(1,2));
# par(mar=c(3,3,0,1),mgp=c(0.2,.75,0)));
par(mfrow=c(1,2));
par(mar=c(3,3,1,1),mgp=c(1.75,.75,0));

for (qoidx in 1:length(qtys)) {
  qtyoff = qtys[qoidx];
  yLim = c(min(log(restbl[,qtyoff+(1:length(legstrs))])), max(log(restbl[,qtyoff+(1:length(legstrs))])));

  # Set up the boxplots
  pstagger = c(-0.35, -0.1, 0.15, 0.2)/2;
  xLim = c(min(nlocs)-max(abs(pstagger)), max(nlocs)+max(abs(pstagger)));

  plty = c('dotted','longdash','solid','dashed');
  pcol = gray(c(0,0,0.5,0.5));

  firstplot=TRUE;

  # -- Iterate over the priors
  for (pidx in 1:length(legstrs)) {
    qtyidx = pidx + qtyoff;
    meanvals = rep(0,length(nlocs));

    # Then over the sample sizes
    for (nidx in 1:length(nlocs)) {
	selidx = restbl$NTRAIN==nvals[nidx];
	boxplot(log(restbl[selidx,qtyidx]), yaxt="n", 
		      outline=0, at=nlocs[nidx]+pstagger[pidx], 
		      xnames=nvals[nidx], add=!firstplot, 
		      boxwex=0.2, xlim=xLim, ylim=yLim);
	meanvals[nidx] = mean(log(restbl[selidx,qtyidx]));
	if(firstplot){firstplot=FALSE;}
    }

    # Plot the join
    lines(nlocs+pstagger[pidx], meanvals, lty=plty[pidx], col=pcol[pidx]);
  }

  axis(side=1, at=nlocs, labels=nvals/1000);
  axis(side=2);

  if (qoidx==1) {
    title(xlab='sample size in thousands', ylab='log M');
  } else {
    title(xlab='sample size in thousands', ylab='log L');
  }

  legend("bottomleft", legend=legstrs, x.intersp=0.2, horiz=TRUE, lty=plty, col=pcol, text.width=0.8, cex=0.8);

}

dev.off();
