%
% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
% scriptlooper : generalized wraparound for these things
% A lot like scriptrunner but with some additional stuff
%
% REQUIRES that the environment set MATLABCODE
% Then add all code subdirectories with in MATLABCODE
codedir = getenv('MATLABCODE');
addpath(codedir);

codelist = dir(codedir);
bSize = size(codelist);
for bidx = 1:bSize(1)
    if ( codelist(bidx).isdir && strcmp(codelist(bidx).name, '..') ~= 1 ...
            && strcmp(codelist(bidx).name, '.svn') ~= 1)
        newdir = strcat(codedir, filesep(), codelist(bidx).name);
        disp(['Adding ' newdir]);
        addpath(newdir);
    end
end

LogIt(sprintf('START\n'), 1, 1);

mworkscript = getenv('MWORKSCRIPT');
msetupscript = getenv('MSETUPSCRIPT');

LogIt(sprintf('workscript  : %s\n', mworkscript), 1, 1);
LogIt(sprintf('setupscript : %s\n', msetupscript), 1, 1);

% Use environment to get the name of the setup script
if isempty(msetupscript)
    error('No setup script provided in SETUPSCRIPT');
else
    evstr = strcat('marg = ', msetupscript, '();');
    try
        eval(evstr);
    catch ME
        error('Error evaluating [%s] : %s', msetupscript, ME.message);
    end
end

% Setup must define an object named marg
if ~exist('marg', 'var')
    error('"marg" object not found after setup');
end

% Add information
marg.MWORKSCRIPT = mworkscript;
marg.MSETUPSCRIPT = msetupscript;

% Show what we have
LogIt(dumpstruct(marg, 0, 3), 1, marg.LOGTHRESH);

lclnsamps = marg.NSAMPS;
uselist = 0;

usenewrng = (isfield(marg, 'NEWRNG') && marg.NEWRNG == 1);

% Check some arguments
if usenewrng
    % NEW STYLE - still assumes you want consistent list lengths
    %                   assumes LISTS and not single seed vals
    nrnglists = 0;
    keepgoing = 1;
    listlen = -1;
    while keepgoing && nrnglists < 100
        fldstr = sprintf('GSEEDLIST%2.2d', nrnglists+1);
        if isfield(marg, fldstr)
            lcllen = length(marg.(fldstr));
            if listlen < 0
                listlen = lcllen;
            elseif listlen >= 0 && lcllen ~= listlen
                LogIt(sprintf('%s had %d elements, expecting %d', fldstr, lcllen, listlen), 1, marg.LOGTHRESH);
                error('UNEQUAL RNG LISTS');
            end
            nrnglists = nrnglists + 1;
        else
            LogIt(sprintf('listidx=%d was not present, stopping\n', nrnglists), 1, marg.LOGTHRESH);
            keepgoing = 0;
        end
    end
    
    if nrnglists <= 0
        LogIt(sprintf('Found no RNG lists, stopping...\n'), 1, marg.LOGTHRESH);
        error('NO RNG LISTS FOUND');
    else
        LogIt(sprintf('Found %d RNG lists of %d seeds\n', nrnglists, listlen), 1, marg.LOGTHRESH);
    end
    
    lclnsamps = listlen;
    uselist = 1;
else
    % OLD STYLE
    if isfield(marg, 'NSEEDLIST') && isfield(marg, 'SEEDLIST')
        if length(marg.NSEEDLIST) == length(marg.SEEDLIST)
            lclnsamps = length(marg.SEEDLIST);
            uselist = 1;
        else
            LogIt(sprintf('NSEEDLIST and SEEDLIST not the same length, defaulting to ordinary\n'), 1, marg.LOGTHRESH);
        end
    else
        LogIt(sprintf('NSEEDLIST and SEEDLIST not both present, using generated vals\n'), 1, marg.LOGTHRESH);
        if isfield(marg, 'NSEEDLIST')
            marg = rmfield(marg, 'NSEEDLIST');
        end

        if isfield(marg, 'SEEDLIST')
            marg = rmfield(marg, 'SEEDLIST');
        end
    end

    % Seed the RNG: overridden by NSEEDLIST and SEEDLIST
    setallseeds(marg);
end

% Script eval string - currently, all work scripts assumed to rely on
% global variable marg
mworkevstr = strcat('mres = ' , mworkscript, '(marg);');

for sampidx = 1:lclnsamps
    marg.logstr = sprintf('[%d]', sampidx);
    marg.sampidx = sampidx;

    % Reset the seed values from the list OR a draw
    if usenewrng
        marg.RNGLIST = zeros(1, nrnglists);
        for lidx = 1 : nrnglists
            fldstr = sprintf('GSEEDLIST%2.2d', lidx);
            marg.RNGLIST(lidx) = marg.(fldstr)(sampidx);
        end
    else
        if uselist==1
            seedarg.rseed = marg.SEEDLIST(sampidx);
            seedarg.nseed = marg.NSEEDLIST(sampidx);
            seedarg.seed = marg.SEEDLIST(sampidx);
            seedarg.logthresh = marg.LOGTHRESH;
            setallseeds(seedarg);
        end

        % Log the seed values and add them to the arg object
        marg = setAndLogSeeds(marg);
    end
    
    % Execute the workscript given the existing values
    try
        eval(mworkevstr);
    catch ME
        % Build a message from the exception stack
        mymsg = '';
        for sidx = 1:length(ME.stack)
            mymsg = sprintf('%s;%s:%s:%d', mymsg, ME.stack(sidx).name, ...
                                                  ME.stack(sidx).file, ...
                                                  ME.stack(sidx).line);
        end
        mymsg = mymsg(1:(end-1));
        mymsg(mymsg==59)=10;
        LogIt(sprintf('ERROR [%s] on eval [%d] of [%s]\n%s\n', ...
            ME.message, sampidx, mworkscript, mymsg), 1, marg.LOGTHRESH);
    end
    
    if exist('mres','var')
        LogIt(sprintf('mres from [%d]\n', sampidx), 1, marg.LOGTHRESH);
    end
end

LogIt(sprintf('END\n'), 1, marg.LOGTHRESH);



