%
% Top-level script for ALL tests
% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
%

% REQUIRES that the environment set MATLABCODE
% Then add all code subdirectories with in MATLABCODE
codedir = getenv('MATLABCODE');
addpath(codedir);

codelist = dir(codedir);
bSize = size(codelist);
for bidx = 1:bSize(1)
    if ( codelist(bidx).isdir && strcmp(codelist(bidx).name, '..') ~= 1 ...
            && strcmp(codelist(bidx).name, '.svn') ~= 1)
        newdir = strcat(codedir, filesep(), codelist(bidx).name);
        disp(['Adding ' newdir]);
        addpath(newdir);
    end
end

% Find out which script we're invoking, and run it
scriptname = getenv('SCRIPTNAME');
if ( strcmpi(scriptname((end-1):end), '.m') == 1)
    scriptname = scriptname(1:(end-2));
end

% Now that we have the name of the thing we want to run, run it
% It should pull all that it needs from the environment
eval(scriptname);

% Clean up the space
clear codedir codelist bSize bidx newdir scriptname;
