% ------------------------------------------------------------------------
% SCRIPT:  sec4run
% AUTHOR:  DAVID KESSLER, dkessler@live.unc.edu
% PURPOSE: Produces raw results presented in Section 4 of the manuscript.
% ------------------------------------------------------------------------

% -- SET THESE TO MATCH YOUR SETUP
matlabdir = 'C:/cygwin/tmp/sec4code';
outdir = 'C:/cygwin/tmp/RERUN';
setenv('MATLABCODE',matlabdir);
addpath(matlabdir);

% -- Load up the settings used to produce the original results
sec4setup;

% ------------------------------------------------------------------------
% -- DEBUG work
% -- IGNORE THIS IF YOU ARE DOING THE FULL REPRODUCTION
if strcmp(getenv('DEBUG'),'1')
    listA = find(ntrainlist==100);
    listB = find(ntrainlist==1000);
    listC = find(ntrainlist==5000);
    listD = find(ntrainlist==40000);
    midx = [listA(1) listB(1) listC(1) listD(1)];

    bignseedlist = nseedlist;
    bigseedlist = seedlist;
    bigntrainlist = ntrainlist;
    nseedlist  = bignseedlist(midx);
    seedlist   = bigseedlist(midx);
    ntrainlist = bigntrainlist(midx); 
end
% ------------------------------------------------------------------------

% -- Clean up environment
safestrs = {'DEBUG'};
clearenv(dirmspmargstrs(), safestrs);

% -- What we need in order to run each of the trials
setenv('CASEFROMTRUE', '1');
setenv('MARGFROMTRUE', '1');
setenv('MSETUPSCRIPT', 'getdirmspargs');
setenv('MWORKSCRIPT', 'dirmsp');
setenv('P1ALPHA', '1152');
setenv('P2ALPHA', '1152/1152');
setenv('P3BASEALPHA', '1/sqrt(1152)');
setenv('P3MARGALPHA', '1152');
setenv('MAXITER', '5000');
setenv('BURNIN', '1000');
setenv('LOGTHRESH', '1');
setenv('TRUEDATAFILE', 'ACS_2010_PUMS_fullpums');
setenv('DVEC', '2 3 2 8 12');
setenv('P3METHOD', 'GAMMAMH');

% -- Akin to "fast.approx" in the DPMM example
setenv('P3ASSUMEDIFFUSE', '0');

setenv('MHVAR', '1');
setenv('P3MHSOURCE', '1');
setenv('MAXFUNEVALS', '2000');
setenv('MASTERSCRIPT', 'scriptlooper');
setenv('NEWRNG', '0');

% ------------------------------------------------------------------------
% -- DEBUG work
% -- IGNORE THIS IF YOU ARE DOING THE FULL REPRODUCTION
if strcmp(getenv('DEBUG'),'1')
    setenv('MAXITER','500');
    setenv('BURNIN', '500');
end
% ------------------------------------------------------------------------

% -- Run each trial and save results
for sidx = 1:numel(seedlist)
    subdir = sprintf('N%6.6d', ntrainlist(sidx));
    [msucc,mmess,mid] = mkdir(outdir, subdir);
    setenv('SEEDLIST', sprintf('%ld',seedlist(sidx)));
    setenv('NSEEDLIST', sprintf('%ld',nseedlist(sidx)));
    setenv('OUTPNAME', sprintf('%s/%s/rerun_%6.6d.txt', outdir, subdir, sidx));
    setenv('NTRAIN', sprintf('%d', ntrainlist(sidx)));
    setenv('NSAMPS', '1');
    
    % -- Creates same name as OUTPNAME but with a '.mat' extension
    scriptlooper;
end

% ------------------------------------------------------------------------
% Set up the list of wildcards for the output files
% ------------------------------------------------------------------------
nlist = unique(ntrainlist);
alist = '';
for sidx = 1:numel(nlist)
    alist = strcat(alist, sprintf(',+N%6.6d/rerun_*.mat+', nlist(sidx)));
end
alist = alist(2:end);

% ------------------------------------------------------------------------
% Run the aggregation job
% ------------------------------------------------------------------------
setenv('HOSTNAME', 'local');
setenv('LSB_JOBID', 'NA');
setenv('SCRIPTNAME', 'dirmspAgg');
setenv('DATADIR', outdir);
setenv('ALIST', alist);
setenv('LOGTAG', 'TRIAL');
setenv('LOGTHRESH', '1');
setenv('OUTPNAME', sprintf('%s/final.txt', outdir));

% -- Generate the aggregated results that we will plot elsewhere
scriptrunner;

% -- Output name will be OUTPNAME minus txt plus mat
outbname = getenv('OUTPNAME');
outbname(length(outbname) - [2 1 0]) = 'mat';
load(outbname);

% ------------------------------------------------------------------------
% -- Export this as a csv file, let R read it in on the other end
combfile = sprintf('%s/resultsCOMB.txt', outdir);
csvwrite(combfile, restbl(:, [NTRAINidx P1LDFMSEidx P2LDFMSEidx P3LDFMSEidx P4LDFMSEidx P1MARGKLidx P2MARGKLidx P3MARGKLidx P4MARGKLidx]));

% ------------------------------------------------------------------------
% -- Then run the "plotres.R" program to generate the final image...
% -- plotres.R will require local modifications to find the resultsCOMB.txt file
% -- and to write the pdf to the appropriate location
% ------------------------------------------------------------------------
disp('Now modify and run plotres.R');
