%
% setAndLogSeeds
% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
% 
% Bad name: this doesn't RESET the seed values, just gets the current ones
% and "resets" them to their current values.  No change in values takes
% place.
%
% This is ANTIQUATED, use rng() for all future work
%
function margout = setAndLogSeeds(marg,logflag)

if nargin < 2
    dolog = 1;
else
    dolog = logflag;
end

% Get current random seed values
slist = rand('twister');
seed = slist(1);
nlist = randn('state');
nseed = nlist(2);

% RESET random generator
rand('twister', double(seed));
randn('state', nseed);

% LOG the currently in-effect seed values in case we want to recreate
if dolog ~= 0
    LogIt(sprintf('%s SEED=%s NSEED=%s\n', marg.logstr, num2str(seed), num2str(nseed)), 1, marg.logthresh);
end

% Add to the object if desired and return the new one
if nargout > 0
    margout = marg;
    margout.SEED = seed;
    margout.NSEED = nseed;
end

end
