%
% Turn a vector/vectors of indices into linear offsets
% Assumed that the "slab" is D x P, or, more generally, D_1 ... D_P
% Inverse, of sorts, for idx2vec
% AUTHOR : DAVID KESSLER, dkessler@live.unc.edu
%
function midx = vec2idx(ivecs, iDvec)

Dvec = reshape(iDvec, 1, numel(iDvec));

dblock = Dvec(2:end);
dblock = dblock(end:-1:1);
cblock = cumprod(dblock);
cblock = [cblock(end:-1:1) 1];

% LINEAR indices into the slab, not necessarily equal vector lengths
midx = sum((ivecs - 1) .* repmat(cblock,size(ivecs,1),1),2) + 1;

end
